Attribute VB_Name = "mdCreateCircle"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Convenience Function to create a circle given its center(centerX,centerY) and radius

Function CreateCircle(centerX As Double, centerY As Double, radius As Double)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim wp As aWorkplane
Set wp = Part.GetActiveWorkplane

Dim sketch As aSketch
Set sketch = Part.GetActiveSketch

Rem To create a circle from the given inputs
Dim plane As zPlane
Set plane = wp.GetGeometry

Dim center As ZVector
Set center = app.GetClass("Vector").CreateVector(centerX, centerY, 0)

Dim curve1 As zCurve
Set curve1 = app.GetClass("BasicCircle").CreateBasicCircle(wp.Get3DVector(center), plane.GetNormal, radius)

Dim circle1 As aLine
Set circle1 = sketch.CreateLine(curve1)

wp.AutoConstrain circle1

Set CreateCircle = circle1

End Function


